<?php
/*--------------------------------------------------------------------
 OnGetProductModelEvent.php 2020-06-24
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2020 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 -------------------------------------------------------------------*/

declare(strict_types=1);

namespace Gambio\Shop\SellingUnit\Database\Unit\Events;

use Gambio\Shop\Language\ValueObjects\LanguageId;
use Gambio\Shop\Product\ValueObjects\ProductId;
use Gambio\Shop\ProductModifiers\Modifiers\Collections\ModifierIdentifierCollectionInterface;
use Gambio\Shop\Properties\Properties\ValueObjects\CombinationId;
use Gambio\Shop\SellingUnit\Database\Unit\Events\Interfaces\OnGetProductModelEventInterface;
use Gambio\Shop\SellingUnit\Unit\ValueObjects\Model;
use ProductDataInterface;
use Psr\EventDispatcher\EventDispatcherInterface;

/**
 * Class OnGetProductModelEvent
 * @package Gambio\Shop\SellingUnit\Database\Unit\Events
 */
class OnGetProductModelEvent extends OnGetProductInfoEvent implements OnGetProductModelEventInterface
{
    /**
     * @var Model
     */
    protected $model;
    
    /**
     * @var CombinationId|null
     */
    protected $combinationId;


    /**
     * OnGetProductModelEvent constructor.
     *
     * @param ProductDataInterface                  $product
     * @param ProductId                             $productId
     * @param ModifierIdentifierCollectionInterface $modifiers
     * @param LanguageId                            $languageId
     * @param EventDispatcherInterface              $dispatcher
     * @param CombinationId                         $combinationId
     */
    public function __construct(
        ProductDataInterface $product,
        ProductId $productId,
        ModifierIdentifierCollectionInterface $modifiers,
        LanguageId $languageId,
        EventDispatcherInterface $dispatcher,
        ?CombinationId $combinationId = null
    ) {

        $this->product       = $product;
        $this->productId     = $productId;
        $this->modifiers     = $modifiers;
        $this->languageId    = $languageId;
        $this->dispatcher    = $dispatcher;
        $this->combinationId = $combinationId;
    }


    /**
     * @return Model
     */
    public function model(): Model
    {
        return $this->model;
    }


    /**
     * @param Model $model
     */
    public function setModel(Model $model): void
    {
        $this->model = $model;
    }


    /**
     * @return CombinationId|null
     */
    public function combinationId(): ?CombinationId
    {
        return $this->combinationId;
    }
}